/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.lucene;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchsupport.dfm.MaskedFieldsConsumer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.indices.IndicesModule;

class FlsStoredFieldVisitor
extends StoredFieldVisitor {
    private static final Logger log = LogManager.getLogger(FlsStoredFieldVisitor.class);
    private static final ImmutableSet<String> META_FIELDS = ImmutableSet.of((Set)IndicesModule.getBuiltInMetadataFields()).with((Object)"_primary_term");
    private final StoredFieldVisitor delegate;
    private final RoleBasedFieldAuthorization.FlsRule flsRule;
    private final RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule;

    public FlsStoredFieldVisitor(StoredFieldVisitor delegate, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule) {
        this.delegate = delegate;
        this.flsRule = flsRule;
        this.fieldMaskingRule = fieldMaskingRule;
        if (log.isDebugEnabled()) {
            log.debug("Created FlsStoredFieldVisitor for " + flsRule + "; " + fieldMaskingRule);
        }
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        if (fieldInfo.name.equals("_source")) {
            try {
                if (this.delegate instanceof MaskedFieldsConsumer) {
                    ((MaskedFieldsConsumer)this.delegate).binaryMaskedField(fieldInfo, DocumentFilter.filter(Format.JSON, value, this.flsRule, this.fieldMaskingRule), f -> this.fieldMaskingRule != null && this.fieldMaskingRule.get((String)f) != null);
                }
                this.delegate.binaryField(fieldInfo, DocumentFilter.filter(Format.JSON, value, this.flsRule, this.fieldMaskingRule));
            }
            catch (DocumentParseException e) {
                throw new ElasticsearchException("Cannot filter source of document", (Throwable)e, new Object[0]);
            }
        } else {
            this.delegate.binaryField(fieldInfo, value);
        }
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return META_FIELDS.contains((Object)fieldInfo.name) || this.flsRule.isAllowed(fieldInfo.name) ? this.delegate.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = this.fieldMaskingRule.get(fieldInfo.name);
        if (field != null) {
            if (this.delegate instanceof MaskedFieldsConsumer) {
                ((MaskedFieldsConsumer)this.delegate).stringMaskedField(fieldInfo, field.apply(value));
            } else {
                this.delegate.stringField(fieldInfo, field.apply(value));
            }
        } else {
            this.delegate.stringField(fieldInfo, value);
        }
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.delegate.intField(fieldInfo, value);
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.delegate.longField(fieldInfo, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.delegate.floatField(fieldInfo, value);
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.delegate.doubleField(fieldInfo, value);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    static class DocumentFilter {
        private final JsonParser parser;
        private final JsonGenerator generator;
        private final RoleBasedFieldAuthorization.FlsRule flsRule;
        private final RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule;
        private String currentName;
        private String fullCurrentName;
        private String fullParentName;
        private Deque<String> nameStack = new ArrayDeque<String>();

        public static byte[] filter(Format format, byte[] bytes, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule) throws DocumentParseException, IOException {
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                byte[] byArray;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    DocumentFilter.filter(format, in, out, flsRule, fieldMaskingRule);
                    byArray = out.toByteArray();
                }
                return byArray;
            }
        }

        public static void filter(Format format, InputStream in, OutputStream out, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule) throws DocumentParseException, IOException {
            try (JsonParser parser = format.getJsonFactory().createParser(in);
                 JsonGenerator generator = format.getJsonFactory().createGenerator(out);){
                new DocumentFilter(parser, generator, flsRule, fieldMaskingRule).copy();
            }
        }

        DocumentFilter(JsonParser parser, JsonGenerator generator, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule) {
            this.parser = parser;
            this.generator = generator;
            this.flsRule = flsRule;
            this.fieldMaskingRule = fieldMaskingRule;
        }

        private void copy() throws IOException {
            JsonToken token;
            boolean skipNext = false;
            JsonToken jsonToken = token = this.parser.currentToken() != null ? this.parser.currentToken() : this.parser.nextToken();
            while (token != null) {
                block25: {
                    block24: {
                        if (skipNext) break block24;
                        switch (token) {
                            case START_OBJECT: {
                                this.generator.writeStartObject();
                                if (this.fullParentName != null) {
                                    this.nameStack.add(this.fullParentName);
                                }
                                this.fullParentName = this.fullCurrentName;
                                break block25;
                            }
                            case START_ARRAY: {
                                this.generator.writeStartArray();
                                break block25;
                            }
                            case END_OBJECT: {
                                this.generator.writeEndObject();
                                this.fullParentName = this.nameStack.isEmpty() ? null : this.nameStack.removeLast();
                                break block25;
                            }
                            case END_ARRAY: {
                                this.generator.writeEndArray();
                                break block25;
                            }
                            case FIELD_NAME: {
                                this.currentName = this.parser.currentName();
                                String string = this.fullCurrentName = this.fullParentName == null ? this.currentName : this.fullParentName + "." + this.currentName;
                                if (META_FIELDS.contains((Object)this.fullCurrentName) || this.flsRule.isAllowed(this.fullCurrentName)) {
                                    this.generator.writeFieldName(this.parser.currentName());
                                } else {
                                    skipNext = true;
                                }
                                break block25;
                            }
                            case VALUE_TRUE: {
                                this.generator.writeBoolean(Boolean.TRUE.booleanValue());
                                break block25;
                            }
                            case VALUE_FALSE: {
                                this.generator.writeBoolean(Boolean.FALSE.booleanValue());
                                break block25;
                            }
                            case VALUE_NULL: {
                                this.generator.writeNull();
                                break block25;
                            }
                            case VALUE_NUMBER_FLOAT: {
                                this.generator.writeNumber(this.parser.getDecimalValue());
                                break block25;
                            }
                            case VALUE_NUMBER_INT: {
                                this.generator.writeNumber(this.parser.getBigIntegerValue());
                                break block25;
                            }
                            case VALUE_STRING: {
                                RoleBasedFieldMasking.FieldMaskingRule.Field field = this.fieldMaskingRule.get(this.fullCurrentName);
                                if (field != null) {
                                    this.generator.writeString(field.apply(this.parser.getText()));
                                } else {
                                    this.generator.writeString(this.parser.getText());
                                }
                                break block25;
                            }
                            case VALUE_EMBEDDED_OBJECT: {
                                this.generator.writeEmbeddedObject(this.parser.getEmbeddedObject());
                                break block25;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected token: " + token);
                            }
                        }
                    }
                    skipNext = false;
                    switch (token) {
                        case START_OBJECT: {
                            this.parser.skipChildren();
                            break;
                        }
                        case START_ARRAY: {
                            this.parser.skipChildren();
                        }
                    }
                }
                token = this.parser.nextToken();
            }
        }
    }
}

